import numpy as np
from itertools import combinations


def give_num(num=16,l=4,m=4):
    a=np.array([x for x in range(num)])
    a=a.reshape([l,m])
    a=np.transpose(a,[1,0])
    a=a.reshape([-1,])
    return a
    
def Generator_matrix(size=16,l=4,m=4):
    num_list=give_num(size,l,m)
    M=np.zeros((size,size))
    for i in range(len(M)):
        num=num_list[i]
        M[i][num]=1
    return M

def is_permutation_matrix(P):
    return np.all(np.sum(P, axis=0) == 1) and np.all(np.sum(P, axis=1) == 1)

def extract_submatrix(M, indices):
    sub_M = M[np.ix_(indices, indices)]
    if is_permutation_matrix(sub_M):
        try:
            np.linalg.inv(sub_M)
            return sub_M
        except np.linalg.LinAlgError:
            return None
    return None

def find_invertible_submatrix(M, new_size=13):
    indices_list = list(combinations(range(16), new_size))
    for indices in indices_list:
        sub_M = extract_submatrix(M, indices)
        if sub_M is not None:
            return sub_M
    return None

if __name__=="__main__":
    M=Generator_matrix(size=16,l=4,m=4)
    print(M)
    sub_M = find_invertible_submatrix(M)
    print(sub_M)
    T_=np.linalg.inv(sub_M)
    print(T_)
    np.savetxt('Generator_matrix_16×16.txt', M , fmt='%d')
    np.savetxt('Generator_matrix_13×13.txt', sub_M , fmt='%d')